﻿#include <filesystem>
#include <iostream>
#include <string>

#include "HandEye.h"

int main()
{
    HandEyeParam param;
    param.poseType       = 0;
    param.isPointCloudMm = false;
    param.isPoseMm       = true;
    param.isPoseDegree   = true;
    param.isEyeInHand    = true;
    for (int i = 0; i < 100; i++) {
        param.dataMask[i] = true;
    }
    // If you don't want some data, set dataMask to false.
    // param.dataMask[3] = false;

    std::string folder            = R"(D:/)";
    std::string cameraXyzFilePath = folder + "cameraCapturePointXyz.txt";
    std::string robotPoseFilePath = folder + "cameraCaptureRobotPose.txt";
    std::string tcpXyzFilePath    = folder + "tcp.txt";

    HandEyeResult result;
    int ret = HandEyeCalibrationTcpTouch(cameraXyzFilePath.c_str(), robotPoseFilePath.c_str(),
                                         tcpXyzFilePath.c_str(), param, result);

    if (ret != 0) {
        std::cout << "HandEyeCalibrationTcpTouch failed, ret = " << ret << std::endl;
        return 0;
    }
    std::cout << "HandEyeCalibrationTcpTouch success" << std::endl;
    std::cout << "Result matrix: " << std::endl;
    for (int i = 0; i < 4; i++) {
        for (int j = 0; j < 4; j++) {
            std::cout << result.matrix[i * 4 + j] << " ";
        }
        std::cout << std::endl;
    }
    std::cout << "Total mean error: " << result.totalMeanError << std::endl;

    return 0;
}